;-----------------------------------------------
;
;Electronic Arts Pirate Busters/Slayer Loader Decrypter
;
;Code by Fungus of Nostalgia 11-2010
;
;(C) 2010 Nostlagia
;
;-----------------------------------------------


		* = $4000

setmainmessage		= $0400
setstatus		= $0569
setstatusmessage	= $0572
setversion		= $0519



	lda #$00
	sta $0289
	sta $0286
	sta $9d
	lda #$c1
	sta $0318
	lda #$80
	sta $0291
	lda #$17
	sta $d018

	lda #$01
	ldx #$00
	ldy #$00
	jsr clearscreen

	lda #<setmainmessage
	pha
	lda #>setmainmessage
	pha
	lda #$0d
	ldx #<maintitle
	ldy #>maintitle
	jsr printmessage

mainloop

	lda #$00
	sta version
	sta filelength
	sta filelength+$01

	lda #$00
	pha
	lda #$08
	pha
	lda #$00
	tax
	ldy #$40
	jsr fillmemory

	jsr waitspace

	lda #<setstatus
	pha
	lda #>setstatus
	pha
	lda #$07
	ldx #<mstatus
	ldy #>mstatus
	jsr printmessage

	lda #<setstatusmessage
	pha
	lda #>setstatusmessage
	pha
	lda #$01
	ldx #<mloading
	ldy #>mloading
	jsr printmessage

	jsr doinitialize
	jsr loadloader

	lda version
	cmp #$01
	beq isver1

	lda filelength+$01
	cmp #$14
	bcc isver2
	
	lda #$02
	sta version
	lda #$31
	sta mpbversion+$12
	jmp ispbuster

isver2

	lda #$03
	sta version
	lda #$30
	sta mpbversion+$12

ispbuster

	lda #<setversion
	pha
	lda #>setversion
	pha
	lda #$01
	ldx #<mpbversion
	ldy #>mpbversion
	jsr printmessage
	jmp dodecrypt

isver1

	lda #<setversion
	pha
	lda #>setversion
	pha
	lda #$01
	ldx #<mpsversion
	ldy #>mpsversion
	jsr printmessage

dodecrypt

	lda version
	cmp #$01
	beq decrypt1
	cmp #$02
	beq decrypt2
	bne decrypt3

decrypt1

	jsr dodecrypt1
	jmp dosave

decrypt2

	jsr dodecrypt2
	jmp dosave

decrypt3

	jsr dodecrypt3

dosave

	lda #<setstatusmessage
	pha
	lda #>setstatusmessage
	pha
	lda #$01
	ldx #<msaving
	ldy #>msaving
	jsr printmessage
	jsr saveloader
	lda #<setstatusmessage
	pha
	lda #>setstatusmessage
	pha
	lda #$01
	ldx #<mdone
	ldy #>mdone
	jsr printmessage
	inc filenamesave+$0c
	lda filenamesave+$0c
	cmp #$3a
	bne dosaveskip
	lda #$30
	sta filenamesave+$0c
	inc filenamesave+$0b

dosaveskip

	jmp mainloop

dodecrypt1

	ldx #$00

decryptloop1

	lda $1600,x
	eor $7000,x
	sta $1600,x
	lda $1700,x
	eor $7100,x
	sta $1700,x
	lda $1800,x
	eor $7200,x
	sta $1800,x
	lda $1900,x
	eor $7300,x
	sta $1900,x
	lda $1a00,x
	eor $7400,x
	sta $1a00,x
	lda $1b00,x
	eor $7500,x
	sta $1b00,x
	lda $1c00,x
	eor $7600,x
	sta $1c00,x
	lda $1d00,x
	eor $7700,x
	sta $1d00,x
	lda $1e00,x
	eor $7800,x
	sta $1e00,x
	lda $1f00,x
	eor $7900,x
	sta $1f00,x
	lda $2000,x
	eor $7a00,x
	sta $2000,x
	lda $2100,x
	eor $7b00,x
	sta $2100,x
	inx
	bne decryptloop1

donedecrypt1

	rts

dodecrypt2

	ldx #$00

decryptloop2

	lda $1600,x
	eor $6000,x
	sta $1600,x
	lda $1700,x
	eor $6100,x
	sta $1700,x
	lda $1800,x
	eor $6200,x
	sta $1800,x
	lda $1900,x
	eor $6300,x
	sta $1900,x
	lda $1a00,x
	eor $6400,x
	sta $1a00,x
	lda $1b00,x
	eor $6500,x
	sta $1b00,x
	lda $1c00,x
	eor $6600,x
	sta $1c00,x
	lda $1d00,x
	eor $6700,x
	sta $1d00,x
	lda $1e00,x
	eor $6800,x
	sta $1e00,x
	lda $1f00,x
	eor $6900,x
	sta $1f00,x
	lda $2000,x
	eor $6a00,x
	sta $2000,x
	lda $2100,x
	eor $6b00,x
	sta $2100,x
	inx
	bne decryptloop2

donedecrypt2

	rts

dodecrypt3

	ldx #$00

decryptloop3

	lda $1200,x
	eor $5000,x
	sta $1200,x
	lda $1300,x
	eor $5100,x
	sta $1300,x
	lda $1400,x
	eor $5200,x
	sta $1400,x
	lda $1500,x
	eor $5300,x
	sta $1500,x
	lda $1600,x
	eor $5400,x
	sta $1600,x
	lda $1700,x
	eor $5500,x
	sta $1700,x
	lda $1800,x
	eor $5600,x
	sta $1800,x
	lda $1900,x
	eor $5700,x
	sta $1900,x
	lda $1a00,x
	eor $5800,x
	sta $1a00,x
	lda $1b00,x
	eor $5900,x
	sta $1b00,x
	lda $1c00,x
	eor $5a00,x
	sta $1c00,x
	lda $1d00,x
	eor $5b00,x
	sta $1d00,x
	lda $1e00,x
	eor $5c00,x
	sta $1e00,x
	lda $1f00,x
	eor $5d00,x
	sta $1f00,x
	inx
	beq donedecrypt3
	jmp decryptloop3

donedecrypt3

	rts

doinitialize

	lda #$03
	ldx #<initialize
	ldy #>initialize
	jsr setnam
	lda #$0f
	tay
	ldx #$08
	jsr setlfs
	jsr open
	lda #$0f
	jmp close

loadloader

	lda #$02
	ldx #$08
	ldy #$02
	jsr setlfs
	lda #$06
	ldx #<filenameloader
	ldy #>filenameloader
	jsr setnam
	jsr open
	lda #$08
	jsr talk
	lda #$62
	jsr tksa
	jsr acptr
	pha
	lda st
	beq byteok1
	pla
	pla
	pla
	jsr eof
	jmp loaderror
	
byteok1
	pla
	cmp #$fa
	beq lversion1
	cmp #$d0
	beq lversion2
	pla
	pla
	jsr eof
	jmp unknownversion

lversion1

	lda #$f7
	sta loadaddress
	lda #$0f
	sta loadaddress+$01
	lda #$01
	sta version
	jmp continueload

lversion2

	lda #$cd
	sta loadaddress
	lda #$0e
	sta loadaddress+$01

continueload

	jsr acptr
	pha
	lda st
	beq byteok2
	pla
	pla
	pla
	jsr eof
	jmp loaderror

byteok2

	pla
	ldy #$00

loadloop

	jsr acptr
	pha
	lda st
	and #$bf
	beq byteok3
	pla
	pla
	pla
	jsr eof
	jmp loaderror

byteok3

	pla
	inc $d020
	sta (loadaddress),y		
	dec $d020
	inc filelength
	bne loadskip
	inc filelength+$01

loadskip

	lda st
	and #$40
	bne eof
	inc loadaddress
	bne loadloop
	inc loadaddress+$01
	bne loadloop

eof
	lda #$02
	jmp close

saveloader

	lda version
	cmp #$01
	beq saveversion1

	lda #$d0
	sta loadstart
	lda #$fe
	sta loadstart+$01
	lda #$cd
	sta loadaddress
	lda #$0e
	sta loadaddress+$01
	bne realsave

saveversion1

	lda #$fa
	sta loadstart
	lda #$ff
	sta loadstart+$01
	lda #$f7
	sta loadaddress
	lda #$0f
	sta loadaddress+$01

realsave

	lda filelength
	clc
	adc loadaddress
	sta loadend
	lda filelength+$01
	adc loadaddress+$01
	sta loadend+$01

	lda #$01
	ldx #$09
	ldy #$01
	jsr setlfs
	lda #$0d
	ldx #<filenamesave
	ldy #>filenamesave
	jsr setnam
	jsr open
	ldx #$01
	jsr chkout
	lda loadstart
	jsr ciout
	lda loadstart+$01
	jsr ciout

	ldy #$00
saveloop

	inc $d020
	lda (loadaddress),y
	dec $d020

	jsr ciout
	lda st
	beq saveok
	pla
	pla
	jmp saveerror

saveok

	inc loadaddress
	bne saveskip
	inc loadaddress+$01

saveskip

	lda loadaddress+$01
	cmp loadend+$01
	bne saveloop
	lda loadaddress
	cmp loadend
	bne saveloop	

	lda #$01
	jmp close

unknownversion

	lda #<setversion
	pha
	lda #>setversion
	pha
	lda #$0a
	ldx #<munknownversion
	ldy #>munknownversion
	jsr printmessage
	lda #$02
	sta $d020
	jmp *

loaderror

	lda #<setstatusmessage
	pha
	lda #>setstatusmessage
	pha
	lda #$0a
	ldx #<mloaderror
	ldy #>mloaderror
	jsr printmessage
	lda #$02
	sta $d020
	jmp *
	
saveerror

	lda #<setstatusmessage
	pha
	lda #>setstatusmessage
	pha
	lda #$0a
	ldx #<msaveerror
	ldy #>msaveerror
	jsr printmessage
	lda #$02
	sta $d020
	jmp *

.include common.asm

;------------------------
;text and variables

version
	.byte $00

filelength

	.byte $00,$00

initialize

	.text "i0:"

filenameloader

	.text "loader"

filenamesave

	.text "loader.dcr 00"

	;      0123456789012345678901234567890123456789

.enc screen

maintitle
	.text " Electronic Arts Pirate Busters/Slayer  "
	.text "            Loader Decrypter            "
	.text "                                        "
	.text "Source in Drive 8 Destination in Drive 9"
	.text "                                        "
	.text "        Press SPACE to Decrypt!         "
	.byte $00

mpbversion

	.text "Pirate Busters v2.0 Detected"
	.byte $00

mpsversion

	.text "Pirate Slayer v1.0 Detected "
	.byte $00

munknownversion

	.text "Unknown Version!"
	.byte $00

mloading

	.text "Loading"
	.byte $00

msaving

	.text "Saving "
	.byte $00

mdone

	.text "Done!  "
	.byte $00

mstatus

	.text "Status :"
	.byte $00

mloaderror

	.text "Load Error!"
	.byte $00

msaveerror

	.text "Save Error!"
	.byte $00	

.enc none

		* = $5000

.binary "decrypt 0.bin"

		* = $6000

.binary "decrypt 1.bin"

		* = $7000

.binary "decrypt 2.bin"